# Analyses for Thompson, Grady, Morrison (2025) Does explaining the meaning of likelihood ratios improve lay understanding?

# Before running this script:
# Install package, if not already installed:
# 		install.packages("abtest")

# Load package:
library(abtest)


# Hypotheses 
prior_prob <- c(0, 0.5, 0, 0.5)
names(prior_prob) <- c("H1", "H+", "H-", "H0")

# Prior parameter vales
prior_par = list(mu_psi=0, sigma_psi=1, mu_beta=0, sigma_beta=1)


# Data

# select and run one of the following data assignments

# effective LR = presented LR, excluding participants with prior odds = 1
# y1 = positive for no-explanation condition
# n1 = total number for no-explanation condition
# y2 = positive for explanation condition
# n2 = total number for explanation condition
data <- list(y1=2, n1=272, y2=7, n2=232)

# effective LR = presented LR, including all participants
# y1 = positive for no-explanation condition
# n1 = total number for no-explanation condition
# y2 = positive for explanation condition
# n2 = total number for explanation condition
data <- list(y1=37, n1=307, y2=39, n2=264)

# posterior odds = presented LR, excluding participants with prior odds = 1
# y1 = positive for explanation condition
# n1 = total number for explanation condition
# y2 = positive for no-explanation condition
# n2 = total number for no-explanation condition
data <- list(y1=31, n1=232, y2=47, n2=272)

# posterior odds = presented LR, including all participants
# y1 = positive for explanation condition
# n1 = total number for explanation condition
# y2 = positive for no-explanation condition
# n2 = total number for no-explanation condition
data <- list(y1=63, n1=264, y2=82, n2=307)



# Test
set.seed(0) # to get same reults each time
AB <- ab_test(data = data, prior_par = prior_par, prior_prob = prior_prob)

# Print results
# the relevant result is "BF+0"
print(AB)




